BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.CLEAN_SSN_FRM_ADDR_JOB');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
      ,start_date      => TO_TIMESTAMP_TZ('2017/09/21 17:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=MONTHLY; BYDAY=-1 SUN'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'STORED_PROCEDURE'
      ,job_action      => 'ADR.CLEAN_SSN_FRM_ADDR'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.CLEAN_SSN_FRM_ADDR_JOB'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.CLEAN_SSN_FRM_ADDR_JOB');
END;
/
BEGIN
  SYS.DBMS_SCHEDULER.DROP_JOB
    (job_name  => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB');
END;
/

BEGIN
  SYS.DBMS_SCHEDULER.CREATE_JOB
    (
       job_name        => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
      ,start_date      => TO_TIMESTAMP_TZ('2017/07/27 11:00:00.000000 -05:00','yyyy/mm/dd hh24:mi:ss.ff tzr')
      ,repeat_interval => 'FREQ=DAILY'
      ,end_date        => NULL
      ,job_class       => 'DEFAULT_JOB_CLASS'
      ,job_type        => 'PLSQL_BLOCK'
      ,job_action      => 'BEGIN LOAD_MISSING_RESIDENT_ADDR_SP(1000); END;'
      ,comments        => NULL
    );
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'RESTARTABLE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'LOGGING_LEVEL'
     ,value     => SYS.DBMS_SCHEDULER.LOGGING_OFF);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'MAX_FAILURES');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'MAX_RUNS');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'STOP_ON_WINDOW_CLOSE'
     ,value     => FALSE);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'JOB_PRIORITY'
     ,value     => 3);
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE_NULL
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'SCHEDULE_LIMIT');
  SYS.DBMS_SCHEDULER.SET_ATTRIBUTE
    ( name      => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB'
     ,attribute => 'AUTO_DROP'
     ,value     => FALSE);

  SYS.DBMS_SCHEDULER.ENABLE
    (name                  => 'ADR.LOAD_MISSING_RESIDENT_ADDR_JOB');
END;
/
